/*
 * Decompiled with CFR 0.152.
 */
package net.pasterdream;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.pasterdream.configuration.PasterdreamConfigClientConfiguration;

public class PlayerHealthHUD
implements IGuiOverlay {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static final ResourceLocation ICON = new ResourceLocation("pasterdream", "textures/screens/paster_widgets.png");
    private double playerHealth = 0.0;
    private long healthUpdateCounter = 0L;

    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float v, int w, int h) {
        boolean highlight;
        if (!((Boolean)PasterdreamConfigClientConfiguration.PASTER_HEALTH_HUD.get()).booleanValue()) {
            return;
        }
        if (!forgeGui.shouldDrawSurvivalElements()) {
            return;
        }
        Font font = forgeGui.m_93082_();
        Player player = (Player)MC.m_91288_();
        if (player == null) {
            return;
        }
        int health = Mth.m_14167_((float)player.m_21223_());
        float playerMaxHealth = player.m_21233_();
        float playerOtherHealth = player.m_6103_();
        forgeGui.setupOverlayRenderState(true, false);
        MC.m_91307_().m_6180_("pd_health");
        RenderSystem.enableBlend();
        int updateCounter = forgeGui.m_93079_();
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (player.f_19802_ > 0 && (double)health != this.playerHealth) {
            this.healthUpdateCounter = updateCounter + ((double)health < this.playerHealth ? 20 : 10);
        }
        int flagColor = player.m_21023_(MobEffects.f_19614_) ? 1 : (player.m_21023_(MobEffects.f_19615_) ? 2 : 0);
        this.playerHealth = health;
        int startCount = highlight ? 84 : 0;
        int x = w / 2 - 91;
        int y = h - 40;
        guiGraphics.m_280218_(ICON, x, y, 0, 0, 85, 10);
        guiGraphics.m_280218_(ICON, x + 1, y + 2, startCount + 1, 10 + 6 * flagColor, (int)(83.0f * ((float)health / playerMaxHealth)), 6);
        String text = String.format("%s/%s", Float.valueOf((float)health + playerOtherHealth), Float.valueOf(playerMaxHealth)).replace(".0", "");
        guiGraphics.m_280488_(font, text, x + (42 - font.m_92895_(text) / 2), y, playerOtherHealth > 0.0f ? Color.YELLOW.getRGB() : Color.WHITE.getRGB());
        forgeGui.leftHeight += 11;
        RenderSystem.disableBlend();
        MC.m_91307_().m_7238_();
    }
}

